/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.attachment.storage.StorageProvider;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.dialogs.StorageProviderDialog;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.widgets.FileDialog;

public class AttachmentAdd
implements Action {
    private static final I18N i18n = Application.getI18n();
    private static final Settings settings = new Settings(AttachmentAdd.class);
    private AttachmentService service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);

    @Override
    public void handleAction(Object context) throws ApplicationException {
        try {
            List<StorageProvider> providers = this.service.getProviders();
            if (providers == null || providers.isEmpty()) {
                throw new ApplicationException(i18n.tr("Keine Speicherorte f\u00fcr Dateianh\u00e4nge verf\u00fcgbar"));
            }
            StorageProvider provider = null;
            if (providers.size() > 1) {
                StorageProviderDialog d = new StorageProviderDialog(1);
                provider = d.getSaved();
                if (provider == null) {
                    provider = (StorageProvider)d.open();
                }
            } else {
                provider = providers.get(0);
            }
            String dir = null;
            String[] files = null;
            if (context instanceof String[]) {
                files = (String[])context;
            } else {
                FileDialog d = new FileDialog(GUI.getShell(), 2);
                d.setText(i18n.tr("Bitte w\u00e4hlen Sie ein oder mehrere hinzuzuf\u00fcgende Dateien aus."));
                d.setFilterPath(settings.getString("lastdir", System.getProperty("user.home")));
                if (d.open() == null) {
                    throw new OperationCanceledException();
                }
                dir = d.getFilterPath();
                files = d.getFileNames();
                settings.setAttribute("lastdir", dir);
            }
            if (files == null || files.length == 0) {
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Keine Dateien ausgew\u00e4hlt"), 2));
                return;
            }
            List<Attachment> existing = this.service.find();
            int added = 0;
            int updated = 0;
            int fail = 0;
            for (String s : files) {
                File f = new File(dir, s);
                if (!f.isFile() || !f.canRead()) {
                    if (files.length == 1) {
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Datei nicht lesbar"), 1));
                        return;
                    }
                    Logger.warn((String)("file " + f + " not readable"));
                    ++fail;
                    continue;
                }
                Attachment a = existing.stream().filter(i -> Objects.equals(i.getFilename(), f.getName())).findFirst().orElse(null);
                if (a != null && !Application.getCallback().askUser(i18n.tr("Datei \"{0}\" existiert bereits. \u00dcberschreiben?"), new String[]{f.getName()}, true)) continue;
                try {
                    if (a != null) {
                        this.service.update(a, f);
                        ++updated;
                        continue;
                    }
                    this.service.add(f, provider.getId());
                    ++added;
                }
                catch (IOException e) {
                    Logger.error((String)("error while adding file " + f), (Throwable)e);
                    ++fail;
                }
            }
            Logger.info((String)("added attachments - added: " + added + ", updated: " + updated + ", failed: " + fail));
            if (added + updated + fail > 0) {
                if (fail > 0) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Hinzugef\u00fcgte Dateien: {0}, aktualisiert: {1}, fehlerhaft: {2}", new String[]{Integer.toString(added), Integer.toString(updated), Integer.toString(fail)}), 2));
                } else if (added > 0 && updated == 0) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Hinzugef\u00fcgte Dateien: {0}", Integer.toString(added)), 0));
                } else {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Hinzugef\u00fcgte Dateien: {0}, aktualisiert: {1}", new String[]{Integer.toString(added), Integer.toString(updated)}), 0));
                }
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException ae) {
        }
        catch (Exception e) {
            Logger.error((String)"unable to add attachment", (Throwable)e);
            throw new ApplicationException(i18n.tr("Hinzuf\u00fcgen der Dateianh\u00e4nge fehlgeschlagen"));
        }
    }
}

